/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.maizegenetics.analysis.gbs.Barcode;
import net.maizegenetics.analysis.gbs.ReadBarcodeResult;
import net.maizegenetics.dna.BaseEncoder;

public class ParseBarcodeRead {
    private static int chunkSize = 32;
    protected int maximumMismatchInBarcodeAndOverhang = 0;
    protected static String[] initialCutSiteRemnant = null;
    protected static int readEndCutSiteRemnantLength;
    static String nullS;
    protected static String[] likelyReadEnd;
    protected static String theEnzyme;
    static int maxBarcodeLength;
    private Barcode[] theBarcodes;
    private long[] quickBarcodeList;
    private HashMap<Long, Integer> quickMap;

    public ParseBarcodeRead(String keyFile, String enzyme, String flowcell, String lane) {
        if (enzyme != null) {
            ParseBarcodeRead.chooseEnzyme(enzyme);
        } else {
            ParseBarcodeRead.chooseEnzyme(this.getKeyFileEnzyme(keyFile));
        }
        int totalBarcodes = this.setupBarcodeFiles(new File(keyFile), flowcell, lane);
        System.out.println("Total barcodes found in lane:" + totalBarcodes);
    }

    public static void chooseEnzyme(String enzyme) {
        if (enzyme.matches("(?i)apek[i1]")) {
            theEnzyme = "ApeKI";
            initialCutSiteRemnant = new String[]{"CAGC", "CTGC"};
            likelyReadEnd = new String[]{"GCAGC", "GCTGC", "GCAGAGAT", "GCTGAGAT"};
            readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)pst[i1]")) {
            theEnzyme = "PstI";
            initialCutSiteRemnant = new String[]{"TGCAG"};
            likelyReadEnd = new String[]{"CTGCAG", "CTGCAAGAT"};
            readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)ecot22[i1]")) {
            theEnzyme = "EcoT22I";
            initialCutSiteRemnant = new String[]{"TGCAT"};
            likelyReadEnd = new String[]{"ATGCAT", "ATGCAAGAT"};
            readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)pas[i1]")) {
            theEnzyme = "PasI";
            initialCutSiteRemnant = new String[]{"CAGGG", "CTGGG"};
            likelyReadEnd = new String[]{"CCCAGGG", "CCCTGGG", "CCCTGAGAT", "CCCAGAGAT"};
            readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)hpaii|(?i)hpa2")) {
            theEnzyme = "HpaII";
            initialCutSiteRemnant = new String[]{"CGG"};
            likelyReadEnd = new String[]{"CCGG", "CCGAGATCGG"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)msp[i1]")) {
            theEnzyme = "MspI";
            initialCutSiteRemnant = new String[]{"CGG"};
            likelyReadEnd = new String[]{"CCGG", "CCGAGATCGG"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)pst[i1]-apek[i1]")) {
            theEnzyme = "PstI-ApeKI";
            initialCutSiteRemnant = new String[]{"TGCAG"};
            likelyReadEnd = new String[]{"GCAGC", "GCTGC", "CTGCAG", "GCAGAGAT", "GCTGAGAT"};
            readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)pst[i1]-ecot22[i1]")) {
            theEnzyme = "PstI-EcoT22I";
            initialCutSiteRemnant = new String[]{"TGCAG", "TGCAT"};
            likelyReadEnd = new String[]{"ATGCAT", "CTGCAG", "CTGCAAGAT", "ATGCAAGAT"};
            readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)pst[i1]-msp[i1]")) {
            theEnzyme = "PstI-MspI";
            initialCutSiteRemnant = new String[]{"TGCAG"};
            likelyReadEnd = new String[]{"CCGG", "CTGCAG", "CCGCTCAGG"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)pst[i1]-taq[i1]")) {
            theEnzyme = "PstI-TaqI";
            initialCutSiteRemnant = new String[]{"TGCAG"};
            likelyReadEnd = new String[]{"TCGA", "CTGCAG", "TCGCTCAGG"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)PaeR7[i1]-Hha[i1]")) {
            theEnzyme = "PaeR7I-HhaI";
            initialCutSiteRemnant = new String[]{"TCGAG"};
            likelyReadEnd = new String[]{"GCGC", "CTCGAG", "GCGAGATC"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)sbf[i1]-msp[i1]")) {
            theEnzyme = "SbfI-MspI";
            initialCutSiteRemnant = new String[]{"TGCAGG"};
            likelyReadEnd = new String[]{"CCGG", "CCTGCAGG", "CCGCTCAGG"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)asis[i1]-msp[i1]")) {
            theEnzyme = "AsiSI-MspI";
            initialCutSiteRemnant = new String[]{"ATCGC"};
            likelyReadEnd = new String[]{"CCGG", "GCGATCGC", "CCGCTCAGG"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)bsshii-msp[i1]|(?i)bssh2-msp[i1]")) {
            theEnzyme = "BssHII-MspI";
            initialCutSiteRemnant = new String[]{"CGCGC"};
            likelyReadEnd = new String[]{"CCGG", "GCGCGC", "CCGCTCAGG"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)fse[i1]-msp[i1]")) {
            theEnzyme = "FseI-MspI";
            initialCutSiteRemnant = new String[]{"CCGGCC"};
            likelyReadEnd = new String[]{"CCGG", "GGCCGGCC", "CCGCTCAGG"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)sal[i1]-msp[i1]")) {
            theEnzyme = "SalI-MspI";
            initialCutSiteRemnant = new String[]{"TCGAC"};
            likelyReadEnd = new String[]{"CCGG", "GTCGAC", "CCGCTCAGG"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)ecor[i1]-msp[i1]")) {
            theEnzyme = "EcoRI-MspI";
            initialCutSiteRemnant = new String[]{"AATTC"};
            likelyReadEnd = new String[]{"CCGG", "GAATTC", "CCGAGATC"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)hindiii-msp[i1]|(?i)hind3-msp[i1]")) {
            theEnzyme = "HindIII-MspI";
            initialCutSiteRemnant = new String[]{"AGCTT"};
            likelyReadEnd = new String[]{"CCGG", "AAGCTT", "CCGAGATC"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)sexa[i1]-sau3a[i1]")) {
            theEnzyme = "SexAI-Sau3AI";
            initialCutSiteRemnant = new String[]{"CCAGGT", "CCTGGT"};
            likelyReadEnd = new String[]{"GATC", "ACCAGGT", "ACCTGGT", "GATCAGATC"};
            readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)bamh[i1l]-mluc[i1]")) {
            theEnzyme = "BamHI-MluCI";
            initialCutSiteRemnant = new String[]{"GATCC"};
            likelyReadEnd = new String[]{"AATT", "GGATCC", "AATTAGATC"};
            readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)psti-msei|(?i)pst1-mse1")) {
            theEnzyme = "PstI-MseI";
            initialCutSiteRemnant = new String[]{"TGCAG"};
            likelyReadEnd = new String[]{"TTAA", "CTGCAG", "TTAAGATC"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)avaii-msei|(?i)ava2-mse1")) {
            theEnzyme = "AvaII-MseI";
            initialCutSiteRemnant = new String[]{"GACC", "GTCC"};
            likelyReadEnd = new String[]{"TTAA", "GGACC", "GGTCC", "TTAAGATC"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)ecori-msei|(?i)ecor1-mse1")) {
            theEnzyme = "EcoRI-MseI";
            initialCutSiteRemnant = new String[]{"AATTC"};
            likelyReadEnd = new String[]{"TTAA", "GAATTC", "TTAAGATC"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)ecori-avaii|(?i)ecor1-ava2")) {
            theEnzyme = "EcoRI-AvaII";
            initialCutSiteRemnant = new String[]{"AATTC"};
            likelyReadEnd = new String[]{"GGACC", "GGTCC", "GAATTC", "GGACAGATC", "GGTCAGATC"};
            readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)ecori-hinfi|(?i)ecor1-hinf1")) {
            theEnzyme = "EcoRI-HinfI";
            initialCutSiteRemnant = new String[]{"AATTC"};
            likelyReadEnd = new String[]{"GAATC", "GACTC", "GAGTC", "GATTC", "GAATTC", "GAATAGATC", "GACTAGATC", "GAGTAGATC", "GATTAGATC"};
            readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)bbvci-mspi|(?i)bbvc1-msp1")) {
            theEnzyme = "BbvCI-MspI";
            initialCutSiteRemnant = new String[]{"TCAGC"};
            likelyReadEnd = new String[]{"CCGG", "CCTCAGC", "CCGAGATC"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)apo[i1]")) {
            theEnzyme = "ApoI";
            initialCutSiteRemnant = new String[]{"AATTC", "AATTT"};
            likelyReadEnd = new String[]{"AAATTC", "AAATTT", "GAATTC", "GAATTT", "AAATTAGAT", "GAATTAGAT"};
            readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)BamH[i1l]")) {
            theEnzyme = "BamHI";
            initialCutSiteRemnant = new String[]{"GATCC"};
            likelyReadEnd = new String[]{"GGATCC", "GGATCAGAT"};
            readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)mse[i1]")) {
            theEnzyme = "MseI";
            initialCutSiteRemnant = new String[]{"TAA"};
            likelyReadEnd = new String[]{"TTAA", "TTAAGAT"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)Sau3A[i1]")) {
            theEnzyme = "Sau3AI";
            initialCutSiteRemnant = new String[]{"GATC"};
            likelyReadEnd = new String[]{"GATC", "GATCAGAT"};
            readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)nde[i1]")) {
            theEnzyme = "NdeI";
            initialCutSiteRemnant = new String[]{"TATG"};
            likelyReadEnd = new String[]{"CATATG", "CATAAGAT"};
            readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)hinp1[i1]")) {
            theEnzyme = "HinP1I";
            initialCutSiteRemnant = new String[]{"CGC"};
            likelyReadEnd = new String[]{"GCGC", "GCGAGAT"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)sbf[i1]")) {
            theEnzyme = "SbfI";
            initialCutSiteRemnant = new String[]{"TGCAGG"};
            likelyReadEnd = new String[]{"CCTGCAGG", "CCTGCAAGAT"};
            readEndCutSiteRemnantLength = 6;
        } else if (enzyme.matches("(?i)hindiii|(?i)hind3")) {
            theEnzyme = "HindIII";
            initialCutSiteRemnant = new String[]{"AGCTT"};
            likelyReadEnd = new String[]{"AAGCTT", "AAGCTAGAT"};
            readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)ecor[i1]")) {
            theEnzyme = "EcoRI";
            initialCutSiteRemnant = new String[]{"AATTC"};
            likelyReadEnd = new String[]{"GAATTC", "GAATTAGAT"};
            readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)cviq[i1]")) {
            theEnzyme = "CviQI";
            initialCutSiteRemnant = new String[]{"TAC"};
            likelyReadEnd = new String[]{"GTAC", "GTAAGATCGG"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)csp6[i1]")) {
            theEnzyme = "Csp6I";
            initialCutSiteRemnant = new String[]{"TAC"};
            likelyReadEnd = new String[]{"GTAC", "GTAAGATCGG"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)RBSTA")) {
            theEnzyme = "RBSTA";
            initialCutSiteRemnant = new String[]{"TA"};
            likelyReadEnd = new String[]{"TTAA", "GTAC", "CTAG", "TTAAGAT", "GTAAGAT", "CTAAGAT"};
            readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)RBSCG")) {
            theEnzyme = "RBSCG";
            initialCutSiteRemnant = new String[]{"CG"};
            likelyReadEnd = new String[]{"CCGC", "TCGA", "GCGC", "CCGG", "ACGT", "CCGAGAT", "TCGAGAT", "GCGAGAT", "ACGAGAT"};
            readEndCutSiteRemnantLength = 3;
        } else {
            System.out.println("The software didn't recognize your cut site.\nCurrently, only the following enzymes are recognized for single enzyme digests:\n  ApeKI\n  ApoI\n  BamHI\n  Csp6I\n  CviQI\n  EcoRI\n  EcoT22I\n  HindIII\n  HinP1I\n  HpaII\n  MseI\n  MspI\n  NdeI\n  PasI\n  PstI\n  Sau3AI\n  SbfI\n  RBSTA\n  RBSCG\nOr the following for two-enzyme digests:\n  AsiSI-MspI\n  AvaII-MseI\n  BamHI-MluCI\n  BbvCI-MspI\n  BssHII-MspI\n  EcoRI-AvaII\n  EcoRI-HinfI\n  EcoRI-MseI\n  EcoRI-MspI\n  FseI-MspI\n  HindIII-MspI\n  HindIII-NlaIII\n  PaeR7I-HhaI\n  PstI-ApeKI\n  PstI-EcoT22I\n  PstI-MseI\n  PstI-MspI\n  PstI-TaqI\n  SalI-MspI\n  SbfI-MspI\n  SexAI-Sau3AI\n");
            System.out.println("For two-enzyme digest, enzyme names should be separated by a dash, e.g. PstI-MspI ");
        }
        System.out.println("Enzyme: " + theEnzyme);
    }

    private String getKeyFileEnzyme(String keyFileName) {
        String result = null;
        try {
            String temp;
            BufferedReader br = new BufferedReader(new FileReader(keyFileName), 65536);
            int currLine = 0;
            while ((temp = br.readLine()) != null) {
                String enzymeName;
                String[] s = temp.split("\\t");
                if (currLine > 0 && !(enzymeName = s.length < 9 ? "" : s[8]).equals("")) {
                    result = enzymeName;
                    break;
                }
                ++currLine;
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't open key file to read Enzyme: " + e);
        }
        return result;
    }

    private int setupBarcodeFiles(File keyFile, String flowcell, String lane) {
        try {
            String temp;
            BufferedReader br = new BufferedReader(new FileReader(keyFile), 65536);
            ArrayList<Barcode> theBarcodesArrayList = new ArrayList<Barcode>();
            while ((temp = br.readLine()) != null) {
                String[] s = temp.split("\\t");
                Barcode theBC = null;
                if (!s[0].equals(flowcell) || !s[1].equals(lane)) continue;
                if (s.length < 8 || s[7] == null || s[7].trim().equals("")) {
                    throw new IllegalArgumentException("Column H of the key file must contain a LibraryPrepID (integer or alphanumeric)");
                }
                theBC = new Barcode(s[2], initialCutSiteRemnant, s[3] + ":" + s[0] + ":" + s[1] + ":" + s[7], flowcell, lane);
                theBarcodesArrayList.add(theBC);
                System.out.println(theBC.barcodeS + " " + theBC.taxaName);
            }
            this.theBarcodes = new Barcode[theBarcodesArrayList.size()];
            theBarcodesArrayList.toArray(this.theBarcodes);
            Arrays.sort(this.theBarcodes);
            int nBL = this.theBarcodes[0].barOverLong.length;
            this.quickBarcodeList = new long[this.theBarcodes.length * nBL];
            this.quickMap = new HashMap();
            for (int i = 0; i < this.theBarcodes.length; ++i) {
                for (int j = 0; j < nBL; ++j) {
                    this.quickBarcodeList[i * nBL + j] = this.theBarcodes[i].barOverLong[j];
                    this.quickMap.put(this.theBarcodes[i].barOverLong[j], i);
                }
            }
            Arrays.sort(this.quickBarcodeList);
        }
        catch (Exception e) {
            System.out.println("Error with setupBarcodeFiles: " + e);
        }
        return this.theBarcodes.length;
    }

    Barcode findBestBarcode(String queryS, int maxDivergence) {
        long query = BaseEncoder.getLongFromSeq(queryS.substring(0, chunkSize));
        int closestHit = Arrays.binarySearch(this.quickBarcodeList, query);
        if (closestHit < -1) {
            int index = this.quickMap.get(this.quickBarcodeList[-(closestHit + 2)]);
            if (this.theBarcodes[index].compareSequence(query, 1) == 0) {
                return this.theBarcodes[index];
            }
            if (maxDivergence == 0) {
                return null;
            }
        } else {
            return null;
        }
        int maxLength = 0;
        int minDiv = maxDivergence + 1;
        int countBest = 0;
        Barcode bestBC = null;
        for (Barcode bc : this.theBarcodes) {
            int div = bc.compareSequence(query, maxDivergence + 1);
            if (div > minDiv) continue;
            if (div < minDiv || bc.barOverLength > maxLength) {
                minDiv = div;
                maxLength = bc.barOverLength;
                bestBC = bc;
                countBest = 1;
                continue;
            }
            bestBC = null;
            ++countBest;
        }
        return bestBC;
    }

    public static ReadBarcodeResult removeSeqAfterSecondCutSite(String seq, byte maxLength) {
        int p;
        int cutSitePosition = 9999;
        ReadBarcodeResult returnValue = new ReadBarcodeResult(seq);
        String match = null;
        for (String potentialCutSite : likelyReadEnd) {
            p = seq.indexOf(potentialCutSite, 1);
            if (p <= 1 || p >= cutSitePosition) continue;
            cutSitePosition = p;
            match = potentialCutSite;
        }
        if (theEnzyme.equalsIgnoreCase("ApeKI") && cutSitePosition == 2 && (match.equalsIgnoreCase("GCAGC") || match.equalsIgnoreCase("GCTGC"))) {
            seq = seq.substring(3, seq.length());
            cutSitePosition = 9999;
            returnValue.unprocessedSequence = seq;
            for (String potentialCutSite : likelyReadEnd) {
                p = seq.indexOf(potentialCutSite, 1);
                if (p <= 1 || p >= cutSitePosition) continue;
                cutSitePosition = p;
            }
        }
        if (cutSitePosition < maxLength) {
            returnValue.length = (byte)(cutSitePosition + readEndCutSiteRemnantLength);
            returnValue.processedSequence = seq.substring(0, cutSitePosition + readEndCutSiteRemnantLength);
        } else if (seq.length() <= 0) {
            returnValue.processedSequence = "";
            returnValue.length = 0;
        } else {
            returnValue.length = (byte)Math.min(seq.length(), maxLength);
            returnValue.processedSequence = seq.substring(0, returnValue.length);
        }
        if (returnValue.length < maxLength) {
            returnValue.paddedSequence = returnValue.processedSequence + nullS;
            returnValue.paddedSequence = returnValue.paddedSequence.substring(0, maxLength);
        } else {
            returnValue.paddedSequence = returnValue.processedSequence.substring(0, maxLength);
            returnValue.length = (byte)maxLength;
        }
        return returnValue;
    }

    public ReadBarcodeResult parseReadIntoTagAndTaxa(String seqS, String qualS, boolean fastq, int minQual) {
        int firstBadBase;
        long[] read = new long[2];
        if (minQual > 0 && qualS != null && (firstBadBase = BaseEncoder.getFirstLowQualityPos(qualS, minQual)) < maxBarcodeLength + 2 * chunkSize) {
            return null;
        }
        int miss = -1;
        miss = fastq ? seqS.lastIndexOf(78, maxBarcodeLength + 2 * chunkSize - 1) : seqS.lastIndexOf(46, maxBarcodeLength + 2 * chunkSize - 1);
        if (miss != -1) {
            return null;
        }
        Barcode bestBarcode = this.findBestBarcode(seqS, this.maximumMismatchInBarcodeAndOverhang);
        if (bestBarcode == null) {
            return null;
        }
        String genomicSeq = seqS.substring(bestBarcode.barLength, seqS.length());
        ReadBarcodeResult tagProcessingResults = ParseBarcodeRead.removeSeqAfterSecondCutSite(genomicSeq, (byte)(2 * chunkSize));
        String hap = tagProcessingResults.paddedSequence;
        read = BaseEncoder.getLongArrayFromSeq(hap);
        byte pos = tagProcessingResults.length;
        ReadBarcodeResult rbr = new ReadBarcodeResult(read, pos, bestBarcode.getTaxaName());
        return rbr;
    }

    public int getBarCodeCount() {
        return this.theBarcodes.length;
    }

    public Barcode getTheBarcodes(int index) {
        return this.theBarcodes[index];
    }

    public String[] getTaxaNames() {
        String[] result = new String[this.getBarCodeCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getTheBarcodes(i).getTaxaName();
        }
        return result;
    }

    static {
        nullS = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
        likelyReadEnd = null;
        theEnzyme = null;
        maxBarcodeLength = 10;
    }
}

