/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import com.google.common.collect.Range;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import net.maizegenetics.gui.DialogUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.PluginParameterTerry;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.util.ExceptionUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ParameterConceptPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ParameterConceptPlugin.class);
    private PluginParameterTerry<String> myInputFile = new PluginParameterTerry.Builder<String>(PARAMETERS.inputFile, null, String.class).required(true).inFile().build();
    private PluginParameterTerry<Double> myMinAlleleFreq = new PluginParameterTerry.Builder<Double>(PARAMETERS.minAlleleFreq, 0.01, Double.class).range((Range<Double>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).units("Ratio").build();
    private PluginParameterTerry<Boolean> myUseReference = new PluginParameterTerry.Builder<Boolean>(PARAMETERS.useReference, false, Boolean.class).build();
    private static final int TEXT_FIELD_WIDTH = 20;
    boolean parametersIsSet = true;

    public ParameterConceptPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    public ParameterConceptPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    public static void main(String[] args) {
        Properties props = new Properties();
        props.setProperty("log4j.logger.net.maizegenetics", "INFO, stdout");
        props.setProperty("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.stdout.layout", "org.apache.log4j.TTCCLayout");
        PropertyConfigurator.configure((Properties)props);
        ParameterConceptPlugin plugin = new Builder(null).setParameter(PARAMETERS.inputFile, "terry.txt").setParameter(PARAMETERS.minAlleleFreq, 0.2).setParameter(PARAMETERS.useReference, true).build();
        plugin.performFunction(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            if (this.isInteractive() && !this.setParametersViaGUI()) {
                DataSet dataSet = null;
                return dataSet;
            }
            this.printParameterValues();
            this.checkParameters();
            DataSet output = this.processData(input);
            if (output != null) {
                this.fireDataSetReturned(new PluginEvent(output, this.getClass()));
            }
            DataSet dataSet = output;
            return dataSet;
        }
        catch (Exception e) {
            if (this.isInteractive()) {
                StringBuilder builder = new StringBuilder();
                builder.append(e.getMessage());
                builder.append("\n");
                String str = builder.toString();
                DialogUtils.showError(str, (Component)this.getParentFrame());
            } else {
                myLogger.error((Object)e.getMessage());
                e.printStackTrace();
            }
            DataSet dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private DataSet processData(DataSet input) {
        return null;
    }

    private List<PluginParameterTerry<?>> getParameterInstances() {
        Field[] fields;
        ArrayList result = new ArrayList();
        for (Field current : fields = this.getClass().getDeclaredFields()) {
            if (!current.getType().isAssignableFrom(PluginParameterTerry.class)) continue;
            try {
                PluginParameterTerry parameter = (PluginParameterTerry)current.get(this);
                result.add(parameter);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("AbstractPlugin: getParameterInstances: problem getting parameter instances");
            }
        }
        return result;
    }

    private Field getParameterField(String key) {
        Field[] fields;
        for (Field current : fields = this.getClass().getDeclaredFields()) {
            if (!current.getType().isAssignableFrom(PluginParameterTerry.class)) continue;
            try {
                PluginParameterTerry parameter = (PluginParameterTerry)current.get(this);
                if (!parameter.cmdLineName().equals(key)) continue;
                return current;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("AbstractPlugin: getParameterField: problem with key: " + key);
            }
        }
        throw new IllegalArgumentException("AbstractPlugin: getParameterField: unknown key: " + key);
    }

    private PluginParameterTerry<?> getParameterInstance(String key) {
        try {
            Field field = this.getParameterField(key);
            return (PluginParameterTerry)field.get(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("AbstractPlugin: getParameterInstance: problem with key: " + key);
        }
    }

    private <T extends Comparable<T>> Class<T> getParameterGeneric(String key) {
        Field[] fields;
        for (Field current : fields = this.getClass().getDeclaredFields()) {
            if (!current.getType().isAssignableFrom(PluginParameterTerry.class)) continue;
            try {
                PluginParameterTerry parameter = (PluginParameterTerry)current.get(this);
                if (!parameter.cmdLineName().equals(key)) continue;
                System.out.println("generic type: " + current.getGenericType());
                return current.getGenericType().getClass();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("AbstractPlugin: getParameter: problem with key: " + key);
            }
        }
        throw new IllegalArgumentException("AbstractPlugin: getParameter: unknown key: " + key);
    }

    public static <T> T convert(String input, Class<T> outputClass) {
        try {
            return input == null ? null : (T)outputClass.getConstructor(String.class).newInstance(input);
        }
        catch (InvocationTargetException nfe) {
            throw new IllegalArgumentException("convert: Problem converting: " + input + " to " + outputClass.getName());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("convert: Unknown type: " + outputClass.getName());
        }
    }

    @Override
    public void setParameters(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (args[i].startsWith("-")) {
                    PluginParameterTerry<?> parameter = this.getParameterInstance(arg = arg.substring(1));
                    if (parameter == null) {
                        myLogger.error((Object)("Unrecognized argument: " + args[i]));
                        this.printUsage();
                        System.exit(1);
                    }
                    if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                        if (parameter.valueType().isAssignableFrom(Boolean.class)) {
                            this.setParameter(arg, Boolean.TRUE);
                            continue;
                        }
                        myLogger.error((Object)("Parameter requires a value: " + args[i]));
                        this.printUsage();
                        System.exit(1);
                        continue;
                    }
                    this.setParameter(arg, args[i + 1]);
                    ++i;
                    continue;
                }
                myLogger.error((Object)("Argument expected to start with dash(-): " + args[i]));
                this.printUsage();
                System.exit(1);
            }
        }
    }

    private void checkParameters() {
        for (PluginParameterTerry<?> current : this.getParameterInstances()) {
            String outFolder;
            File outDir;
            String filename;
            Object value;
            if (current.required() && ((value = current.value()) == null || value.toString().trim().length() == 0)) {
                if (this.isInteractive()) {
                    throw new IllegalStateException(current.guiName() + " must be defined.");
                }
                myLogger.error((Object)("-" + current.cmdLineName() + " is required.\n"));
                this.printUsage();
                System.exit(1);
            }
            if (current.fileType() == PluginParameterTerry.FILE_TYPE.IN && !new File(filename = current.value().toString()).exists()) {
                if (this.isInteractive()) {
                    throw new IllegalStateException(current.guiName() + ": " + filename + " doesn't exist.");
                }
                myLogger.error((Object)("-" + current.cmdLineName() + ": " + filename + " doesn't exist\n"));
                this.printUsage();
                System.exit(1);
            }
            if (current.fileType() != PluginParameterTerry.FILE_TYPE.OUT || (outDir = new File(outFolder = Utils.getDirectory(filename = current.value().toString()))).isDirectory()) continue;
            if (this.isInteractive()) {
                throw new IllegalStateException(current.guiName() + ": Output Directory: " + outFolder + " doesn't exist.");
            }
            myLogger.error((Object)("-" + current.cmdLineName() + ": Output Directory: " + outFolder + " doesn't exist\n"));
            this.printUsage();
            System.exit(1);
        }
    }

    private void printParameterValues() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        builder.append(Utils.getBasename(this.getClass().getName()));
        builder.append(" Parameters\n");
        for (PluginParameterTerry<?> current : this.getParameterInstances()) {
            builder.append(current.cmdLineName());
            builder.append(": ");
            builder.append(current.value());
            builder.append("\n");
        }
        myLogger.info((Object)builder.toString());
    }

    private void printUsage() {
        StringBuilder builder = new StringBuilder();
        builder.append("\nUsage:\n");
        builder.append(Utils.getBasename(this.getClass().getName())).append(" <options>\n");
        for (PluginParameterTerry<?> current : this.getParameterInstances()) {
            builder.append("-");
            builder.append(current.cmdLineName());
            builder.append(" ");
            if (current.valueType().isAssignableFrom(Boolean.class)) {
                builder.append("<true | false>");
            } else {
                builder.append("<");
                builder.append(current.guiName());
                builder.append(">");
            }
            builder.append(" : ");
            builder.append(current.description());
            if (current.range() != null) {
                builder.append(" ");
                builder.append(current.range().toString());
            }
            if (current.required()) {
                builder.append(" (required)");
            }
            builder.append("\n");
        }
        myLogger.info((Object)builder.toString());
    }

    public String inputFile() {
        return this.myInputFile.value();
    }

    public Object getParameter(Enum key) {
        return this.getParameterInstance(key.toString()).value();
    }

    protected <T extends Comparable<T>> ParameterConceptPlugin setParameter(String key, T value) {
        block7: {
            PluginParameterTerry parameter = null;
            try {
                Field field = this.getParameterField(key);
                parameter = (PluginParameterTerry)field.get(this);
                if (parameter == null) {
                    throw new IllegalArgumentException("setParameter: Unknown Parameter: " + key);
                }
                if (parameter.range() != null && !parameter.range().contains(value)) {
                    throw new IllegalArgumentException("setParameter: " + parameter.cmdLineName() + " value: " + value.toString() + " outside range: " + parameter.range().toString());
                }
                PluginParameterTerry<T> newParameter = new PluginParameterTerry<T>(parameter, value);
                field.set(this, newParameter);
            }
            catch (Exception e) {
                if (this.isInteractive()) {
                    try {
                        throw e;
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                        break block7;
                    }
                }
                myLogger.error((Object)(key + ": " + e.getMessage()));
                this.printUsage();
                System.exit(1);
            }
        }
        return this;
    }

    protected <T extends Comparable<T>> ParameterConceptPlugin setParameter(String key, String value) {
        PluginParameterTerry<?> parameter = null;
        try {
            System.out.println("generic: " + this.getParameterGeneric(key));
            parameter = this.getParameterInstance(key);
            return this.setParameter(key, (Comparable)ParameterConceptPlugin.convert(value, parameter.valueType()));
        }
        catch (Exception e) {
            if (this.isInteractive()) {
                throw e;
            }
            myLogger.error((Object)(key + ": " + e.getMessage()));
            this.printUsage();
            System.exit(1);
            return this;
        }
    }

    protected <T extends Comparable<T>> ParameterConceptPlugin setParameter(Enum<PARAMETERS> key, T value) {
        return this.setParameter(key.toString(), value);
    }

    protected <T extends Comparable<T>> ParameterConceptPlugin setParameter(Enum<PARAMETERS> key, String value) {
        return this.setParameter(key.toString(), value);
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Parameter Concept";
    }

    @Override
    public String getToolTipText() {
        return "Parameter Concept Plugin";
    }

    @Override
    public String getCitation() {
        return "Casstevens T (2014) TASSEL: Self-Describing Plugins. Publication 1:1.";
    }

    protected <T extends Comparable<T>> boolean setParametersViaGUI() {
        final JDialog dialog = new JDialog(this.getParentFrame(), null, true);
        final HashMap<String, JComponent> parameterFields = new HashMap<String, JComponent>();
        this.parametersIsSet = true;
        JButton okButton = new JButton();
        okButton.setActionCommand("Ok");
        okButton.setText("Ok");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    for (PluginParameterTerry current : ParameterConceptPlugin.this.getParameterInstances()) {
                        JComponent component = (JComponent)parameterFields.get(current.cmdLineName());
                        if (component instanceof JTextField) {
                            String input = ((JTextField)component).getText().trim();
                            ParameterConceptPlugin.this.setParameter(current.cmdLineName(), input);
                            continue;
                        }
                        if (!(component instanceof JCheckBox)) continue;
                        if (((JCheckBox)component).isSelected()) {
                            ParameterConceptPlugin.this.setParameter(current.cmdLineName(), Boolean.TRUE);
                            continue;
                        }
                        ParameterConceptPlugin.this.setParameter(current.cmdLineName(), Boolean.FALSE);
                    }
                }
                catch (Exception ex) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Problem Setting Parameters: ");
                    builder.append("\n");
                    builder.append(Utils.shortenStrLineLen(ExceptionUtils.getExceptionCauses(ex), 50));
                    String str = builder.toString();
                    DialogUtils.showError(str, (Component)ParameterConceptPlugin.this.getParentFrame());
                    return;
                }
                dialog.setVisible(false);
            }
        });
        JButton cancelButton = new JButton();
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterConceptPlugin.this.parametersIsSet = false;
                dialog.setVisible(false);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        for (final PluginParameterTerry<?> current : this.getParameterInstances()) {
            if (current.valueType().isAssignableFrom(Boolean.class)) {
                JCheckBox check = new JCheckBox(current.guiName());
                if (current.value() == Boolean.TRUE) {
                    check.setSelected(true);
                } else {
                    check.setSelected(false);
                }
                JPanel temp = new JPanel(new FlowLayout(0));
                temp.add(check);
                panel.add(temp);
                parameterFields.put(current.cmdLineName(), check);
                continue;
            }
            final JTextField field = current.fileType() == PluginParameterTerry.FILE_TYPE.IN || current.fileType() == PluginParameterTerry.FILE_TYPE.OUT ? new JTextField(15) : new JTextField(20);
            if (current.value() != null) {
                field.setText(current.value().toString());
            }
            if (current.range() != null) {
                field.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        String input = field.getText().trim();
                        try {
                            Comparable value = (Comparable)ParameterConceptPlugin.convert(input, current.valueType());
                            if (!current.range().contains(value)) {
                                JOptionPane.showMessageDialog(dialog, current.guiName() + " range: " + current.range().toString());
                                field.setText(ParameterConceptPlugin.this.getParameterInstance(current.cmdLineName()).value().toString());
                            }
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(dialog, current.guiName() + ": " + ex.getMessage());
                            field.setText(ParameterConceptPlugin.this.getParameterInstance(current.cmdLineName()).value().toString());
                        }
                    }
                });
            }
            if (current.fileType() == PluginParameterTerry.FILE_TYPE.IN) {
                panel.add(this.getLine(current.guiName(), field, this.getOpenFile(dialog, field)));
            } else if (current.fileType() == PluginParameterTerry.FILE_TYPE.OUT) {
                panel.add(this.getLine(current.guiName(), field, this.getSaveFile(dialog, field)));
            } else {
                panel.add(this.getLine(current.guiName(), field, null));
            }
            parameterFields.put(current.cmdLineName(), field);
        }
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add((Component)panel, this.getToolTipText());
        JPanel pnlButtons = new JPanel();
        pnlButtons.setLayout(new FlowLayout());
        pnlButtons.add(okButton);
        pnlButtons.add(cancelButton);
        dialog.getContentPane().add((Component)tabbedPane, "Center");
        dialog.getContentPane().add((Component)pnlButtons, "South");
        dialog.pack();
        dialog.setResizable(false);
        dialog.setLocationRelativeTo(this.getParentFrame());
        dialog.setVisible(true);
        return this.parametersIsSet;
    }

    private JPanel getLine(String label, JTextField ref, JButton button) {
        JPanel result = new JPanel(new FlowLayout(2));
        result.add(new JLabel(label));
        ref.setEditable(true);
        ref.setHorizontalAlignment(2);
        ref.setAlignmentX(0.5f);
        ref.setAlignmentY(0.5f);
        ref.setMaximumSize(ref.getPreferredSize());
        result.add(ref);
        if (button != null) {
            result.add(button);
        }
        return result;
    }

    private JButton getOpenFile(final JDialog parent, final JTextField textField) {
        final JFileChooser fileChooser = new JFileChooser(TasselPrefs.getOpenDir());
        JButton result = new JButton("Browse");
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (fileChooser.showOpenDialog(parent) == 0) {
                    File file = fileChooser.getSelectedFile();
                    textField.setText(file.getPath());
                    TasselPrefs.putOpenDir(fileChooser.getCurrentDirectory().getPath());
                }
            }
        });
        return result;
    }

    private JButton getSaveFile(final JDialog parent, final JTextField textField) {
        final JFileChooser fileChooser = new JFileChooser(TasselPrefs.getSaveDir());
        JButton result = new JButton("Browse");
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (fileChooser.showSaveDialog(parent) == 0) {
                    File file = fileChooser.getSelectedFile();
                    textField.setText(file.getPath());
                    TasselPrefs.putSaveDir(fileChooser.getCurrentDirectory().getPath());
                }
            }
        });
        return result;
    }

    public static class Builder {
        private final ParameterConceptPlugin myPlugin;

        public Builder(Frame frame) {
            this.myPlugin = new ParameterConceptPlugin(frame);
        }

        protected <T extends Comparable<T>> Builder setParameter(Enum<PARAMETERS> key, T value) {
            this.myPlugin.setParameter(key.toString(), value);
            return this;
        }

        public ParameterConceptPlugin build() {
            return this.myPlugin;
        }
    }

    public static enum PARAMETERS {
        inputFile,
        useReference,
        minAlleleFreq;

    }
}

