/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.map.TOPMInterface;
import net.maizegenetics.dna.map.TOPMUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class KeepSpecifiedSitesInTOPMPlugin
extends AbstractPlugin {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private final Logger myLogger = Logger.getLogger(KeepSpecifiedSitesInTOPMPlugin.class);
    private static String SITE_LIST_FILENAME_REGEX = "(?i).*\\.txt$";
    private static int PAD_POSITION = 300;
    private ArgsEngine myArgsEngine = null;
    private String[] mySiteListFileNames = null;
    private String myOutputFilename = null;
    private String myOrigFilename = null;
    private TOPMInterface myOrigTOPM = null;
    private int myOrigTagCount = 0;
    private byte[][] myOrigVariantOff = null;
    private byte[][] myOrigVariantDef = null;
    private int[] myNumVariantsKeptPerChrom = new int[20];
    private int[] myTagsWithVariants = new int[20];

    public KeepSpecifiedSitesInTOPMPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        int x;
        this.myOrigTOPM = TOPMUtils.readTOPM(this.myOrigFilename);
        this.myOrigTagCount = this.myOrigTOPM.getTagCount();
        this.myLogger.info((Object)("performFunction: Number of Original Tags: " + this.myOrigTagCount));
        this.myOrigVariantOff = this.myOrigTOPM.getVariantOff();
        this.myOrigVariantDef = this.myOrigTOPM.getVariantDef();
        this.myOrigTOPM.clearVariants();
        for (int i = 0; i < this.mySiteListFileNames.length; ++i) {
            if (this.mySiteListFileNames[i].equals(this.myOrigFilename)) continue;
            this.processSiteList(this.mySiteListFileNames[i]);
        }
        for (x = 0; x < this.myNumVariantsKeptPerChrom.length; ++x) {
            if (this.myNumVariantsKeptPerChrom[x] == 0) continue;
            this.myLogger.info((Object)("performFunction: chromosome: " + x + " variants kept: " + this.myNumVariantsKeptPerChrom[x]));
        }
        for (x = 0; x < this.myTagsWithVariants.length; ++x) {
            if (this.myTagsWithVariants[x] == 0) continue;
            this.myLogger.info((Object)("performFunction: Chromosome: " + x + " Number Tags with Variants Defined: " + this.myTagsWithVariants[x]));
        }
        TOPMUtils.writeTOPM(this.myOrigTOPM, this.myOutputFilename);
        return null;
    }

    private void printUsage() {
        this.myLogger.info((Object)"\n\n\nThe options for the KeepSpecifiedSitesInTOPMPlugin are:\n   -input   Input directory containing Site List files\n   -orig    Original TOPM\n   -result  Output, site-filtered TOPM\n\n\n");
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-input", "-input", true);
            this.myArgsEngine.add("-orig", "-orig", true);
            this.myArgsEngine.add("-result", "-result", true);
        }
        this.myArgsEngine.parse(args);
        String tempDirectory = this.myArgsEngine.getString("-input");
        if (tempDirectory != null && tempDirectory.length() != 0) {
            File topmDirectory = new File(tempDirectory);
            if (!topmDirectory.isDirectory()) {
                this.printUsage();
                throw new IllegalArgumentException("KeepSpecifiedSitesInTOPMPlugin: setParameters: The input name you supplied is not a directory: " + tempDirectory);
            }
            this.mySiteListFileNames = DirectoryCrawler.listFileNames(SITE_LIST_FILENAME_REGEX, topmDirectory.getAbsolutePath());
            if (this.mySiteListFileNames.length == 0 || this.mySiteListFileNames == null) {
                this.printUsage();
                throw new IllegalArgumentException("KeepSpecifiedSitesInTOPMPlugin: setParameters: No Site List files in: " + tempDirectory);
            }
            this.myLogger.info((Object)"setParameters: Using these Site List files:");
            for (String filename : this.mySiteListFileNames) {
                this.myLogger.info((Object)("setParameters: found site list: " + filename));
            }
        }
        this.myOrigFilename = this.myArgsEngine.getString("-orig");
        if (this.myOrigFilename == null || this.myOrigFilename.length() == 0) {
            this.printUsage();
            throw new IllegalArgumentException("KeepSpecifiedSitesInTOPMPlugin: setParameters: Must define original file");
        }
        File origFile = new File(this.myOrigFilename);
        if (!origFile.exists()) {
            this.printUsage();
            throw new IllegalArgumentException("KeepSpecifiedSitesInTOPMPlugin: setParameters: The original file doesn't exist: " + this.myOrigFilename);
        }
        this.myOutputFilename = this.myArgsEngine.getString("-result");
        if (this.myOutputFilename == null || this.myOutputFilename.length() == 0) {
            this.printUsage();
            throw new IllegalArgumentException("KeepSpecifiedSitesInTOPMPlugin: setParameters: Must define result file");
        }
        File outputFile = new File(this.myOutputFilename);
        if (outputFile.exists()) {
            this.printUsage();
            throw new IllegalArgumentException("KeepSpecifiedSitesInTOPMPlugin: setParameters: The output file already exists: " + this.myOutputFilename);
        }
    }

    private void processSiteList(String filename) {
        this.myLogger.info((Object)("processSiteList: " + filename));
        BufferedReader reader = Utils.getBufferedReader(filename);
        try {
            int i;
            ArrayList<Integer> positions = new ArrayList<Integer>();
            String line = reader.readLine();
            String chr = WHITESPACE_PATTERN.split(line)[0];
            while (line != null) {
                String[] tokens = WHITESPACE_PATTERN.split(line);
                if (tokens.length != 2) {
                    throw new IllegalArgumentException("KeepSpecifiedSitesInTOPMPlugin: processSiteList: file not correctly formatted: " + filename);
                }
                if (!tokens[0].equals(chr)) {
                    throw new IllegalArgumentException("KeepSpecifiedSitesInTOPMPlugin: processSiteList: all positions must be from same chromosome: " + filename);
                }
                positions.add(Integer.valueOf(tokens[1]));
                line = reader.readLine();
            }
            reader.close();
            int numPositions = positions.size();
            int[] orderedPositions = new int[numPositions];
            for (int j = 0; j < numPositions; ++j) {
                orderedPositions[j] = (Integer)positions.get(j);
            }
            Arrays.sort(orderedPositions);
            int[] numTagsWithUnfoundSitesAndMaxVariants = new int[numPositions];
            int numVariants = this.myOrigVariantOff[0].length;
            int chrInt = Integer.valueOf(chr);
            int tagCount = this.myOrigTOPM.getTagCount();
            for (i = 0; i < tagCount; ++i) {
                int tagPosition;
                int x;
                int currentPosition;
                boolean found;
                int variantAdded;
                int posIndex;
                if (this.myOrigTOPM.getChromosome(i) != chrInt) continue;
                int startPos = this.myOrigTOPM.getStartPosition(i);
                int endPos = this.myOrigTOPM.getEndPosition(i);
                byte strand = this.myOrigTOPM.getStrand(i);
                if (strand == -1) {
                    if (endPos > startPos) {
                        throw new IllegalStateException("KeepSpecifiedSitesInTOPMPlugin: processSiteList: tag: " + i + " strand: " + strand + " end pos: " + endPos + " is greater than start pos: " + startPos);
                    }
                    posIndex = Arrays.binarySearch(orderedPositions, Math.max(endPos - PAD_POSITION, 0));
                    if (posIndex < 0) {
                        posIndex = -(posIndex + 1);
                    }
                    variantAdded = 0;
                    while (posIndex < numPositions && orderedPositions[posIndex] <= startPos + PAD_POSITION) {
                        found = false;
                        currentPosition = orderedPositions[posIndex];
                        for (x = 0; x < numVariants; ++x) {
                            if (this.myOrigVariantOff[i][x] == -128 || this.myOrigVariantDef[i][x] == -128 || (tagPosition = this.myOrigVariantOff[i][x] + startPos) != currentPosition) continue;
                            found = true;
                            this.myOrigTOPM.addVariant(i, this.myOrigVariantOff[i][x], this.myOrigVariantDef[i][x]);
                            variantAdded = 1;
                            if (chrInt >= this.myNumVariantsKeptPerChrom.length) continue;
                            int n = chrInt;
                            this.myNumVariantsKeptPerChrom[n] = this.myNumVariantsKeptPerChrom[n] + 1;
                        }
                        if (found) {
                            numTagsWithUnfoundSitesAndMaxVariants[posIndex] = -1;
                        } else if (!found && numVariants == this.myOrigTOPM.getMaxNumVariants() && numTagsWithUnfoundSitesAndMaxVariants[posIndex] != -1 && currentPosition <= startPos && currentPosition >= endPos) {
                            int n = posIndex;
                            numTagsWithUnfoundSitesAndMaxVariants[n] = numTagsWithUnfoundSitesAndMaxVariants[n] + 1;
                        }
                        ++posIndex;
                    }
                    int n = chrInt;
                    this.myTagsWithVariants[n] = this.myTagsWithVariants[n] + variantAdded;
                    continue;
                }
                if (strand == 1) {
                    if (startPos > endPos) {
                        throw new IllegalStateException("KeepSpecifiedSitesInTOPMPlugin: processSiteList: tag: " + i + " strand: " + strand + " start pos: " + startPos + " is greater than end pos: " + endPos);
                    }
                    posIndex = Arrays.binarySearch(orderedPositions, Math.max(startPos - PAD_POSITION, 0));
                    if (posIndex < 0) {
                        posIndex = -(posIndex + 1);
                    }
                    variantAdded = 0;
                    while (posIndex < numPositions && orderedPositions[posIndex] <= endPos + PAD_POSITION) {
                        found = false;
                        currentPosition = orderedPositions[posIndex];
                        for (x = 0; x < numVariants; ++x) {
                            if (this.myOrigVariantOff[i][x] == -128 || this.myOrigVariantDef[i][x] == -128 || (tagPosition = this.myOrigVariantOff[i][x] + startPos) != currentPosition) continue;
                            found = true;
                            this.myOrigTOPM.addVariant(i, this.myOrigVariantOff[i][x], this.myOrigVariantDef[i][x]);
                            variantAdded = 1;
                            if (chrInt >= this.myNumVariantsKeptPerChrom.length) continue;
                            int n = chrInt;
                            this.myNumVariantsKeptPerChrom[n] = this.myNumVariantsKeptPerChrom[n] + 1;
                        }
                        if (found) {
                            numTagsWithUnfoundSitesAndMaxVariants[posIndex] = -1;
                        } else if (!found && numVariants == this.myOrigTOPM.getMaxNumVariants() && numTagsWithUnfoundSitesAndMaxVariants[posIndex] != -1 && currentPosition >= startPos && currentPosition <= endPos) {
                            int n = posIndex;
                            numTagsWithUnfoundSitesAndMaxVariants[n] = numTagsWithUnfoundSitesAndMaxVariants[n] + 1;
                        }
                        ++posIndex;
                    }
                    int n = chrInt;
                    this.myTagsWithVariants[n] = this.myTagsWithVariants[n] + variantAdded;
                    continue;
                }
                throw new IllegalStateException("KeepSpecifiedSitesInTOPMPlugin: processSiteList: tag: " + i + " unknown strand: " + strand);
            }
            for (i = 0; i < numPositions; ++i) {
                if (numTagsWithUnfoundSitesAndMaxVariants[i] <= 0) continue;
                this.myLogger.info((Object)("chromosome: " + chrInt + " position: " + orderedPositions[i] + " tags with no variant info: " + numTagsWithUnfoundSitesAndMaxVariants[i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("KeepSpecifiedSitesInTOPMPlugin: processSiteList: Problem processing: " + filename);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

