/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class MLMNewOptionDialog
extends JDialog
implements ActionListener {
    JCheckBox chkP3D = new JCheckBox("P3D (Compute variance estimates once)", true);
    JCheckBox chkCompression = new JCheckBox("Compression", true);
    JCheckBox chkNoMarkers = new JCheckBox("Do not test markers", false);
    JCheckBox chkUPGMA = new JCheckBox("UPGMA", true);
    JCheckBox chkNJ = new JCheckBox("Neighbor Joining", false);
    JCheckBox chkAvg = new JCheckBox("Average", true);
    JCheckBox chkMin = new JCheckBox("Minimum", false);
    JCheckBox chkMax = new JCheckBox("Maximum", false);
    JCheckBox chkMedian = new JCheckBox("Median", false);
    JTextField txtGroupFrom = new JTextField(5);
    JTextField txtGroupTo = new JTextField(5);
    JTextField txtGroupBy = new JTextField(5);
    JTextField txtGroupNumberList = new JTextField(30);
    JTextField txtCompFrom = new JTextField(5);
    JTextField txtCompTo = new JTextField(5);
    JTextField txtCompBy = new JTextField(5);
    JTextField txtCompNumberList = new JTextField(30);
    JTextField txtCompressionFrom = new JTextField(5);
    JTextField txtCompressionTo = new JTextField(5);
    JTextField txtCompressionLevels = new JTextField(5);
    JRadioButton radioGroupRange = new JRadioButton("Range", false);
    JRadioButton radioGroupList = new JRadioButton("List (comma-separated numbers)", false);
    JRadioButton radioCompRange = new JRadioButton("Range", true);
    JRadioButton radioCompList = new JRadioButton("List (comma-separated numbers)", false);

    MLMNewOptionDialog(Frame parentFrame) {
        super(parentFrame, true);
        this.setTitle("MLM Options");
        this.setSize(new Dimension(350, 300));
        this.setLocationRelativeTo(this.getParent());
        Container theContentPane = this.getContentPane();
        theContentPane.setLayout(new BorderLayout());
        JPanel optionPanel = new JPanel(new GridBagLayout());
        optionPanel.setBorder(BorderFactory.createTitledBorder("MLM Options"));
        JPanel compressionPanel = new JPanel(new GridBagLayout());
        JPanel groupNumberPanel = new JPanel(new GridBagLayout());
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        String gnPanelTitle = "Specify Compression Levels or Group Sizes to Test";
        compressionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 2, 4, 2), BorderFactory.createTitledBorder("Compression Options")));
        groupNumberPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 8, 2), BorderFactory.createTitledBorder(gnPanelTitle)));
        this.chkCompression.addActionListener(this);
        this.chkCompression.setActionCommand("compress");
        this.chkNoMarkers.addActionListener(this);
        this.chkNoMarkers.setActionCommand("nomarkers");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        optionPanel.add((Component)this.chkP3D, gbc);
        gbc.gridy = 1;
        optionPanel.add((Component)this.chkCompression, gbc);
        gbc.gridy = 2;
        optionPanel.add((Component)this.chkNoMarkers, gbc);
        theContentPane.add((Component)optionPanel, "North");
        ButtonGroup numberGroup = new ButtonGroup();
        numberGroup.add(this.radioGroupRange);
        numberGroup.add(this.radioGroupList);
        numberGroup.add(this.radioCompRange);
        numberGroup.add(this.radioCompList);
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 4, 2, 4);
        compressionPanel.add((Component)new JLabel("Clustering Algorithm"), gbc);
        ++gbc.gridx;
        compressionPanel.add((Component)this.chkUPGMA, gbc);
        ++gbc.gridy;
        compressionPanel.add((Component)this.chkNJ, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        compressionPanel.add((Component)new JLabel("Group Kinship"), gbc);
        ++gbc.gridx;
        compressionPanel.add((Component)this.chkAvg, gbc);
        ++gbc.gridy;
        compressionPanel.add((Component)this.chkMin, gbc);
        ++gbc.gridy;
        compressionPanel.add((Component)this.chkMax, gbc);
        ++gbc.gridy;
        compressionPanel.add((Component)this.chkMedian, gbc);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(6, 4, 6, 4);
        groupNumberPanel.add((Component)new JLabel("Compression Levels"), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(6, 4, 6, 4);
        groupNumberPanel.add((Component)this.radioCompRange, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        groupNumberPanel.add((Component)new JLabel("From"), gbc);
        ++gbc.gridx;
        gbc.anchor = 17;
        groupNumberPanel.add((Component)this.txtCompFrom, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        groupNumberPanel.add((Component)new JLabel("To"), gbc);
        ++gbc.gridx;
        gbc.anchor = 17;
        groupNumberPanel.add((Component)this.txtCompTo, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        groupNumberPanel.add((Component)new JLabel("By"), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        groupNumberPanel.add((Component)this.txtCompBy, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
        groupNumberPanel.add((Component)this.radioCompList, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 6;
        groupNumberPanel.add((Component)this.txtCompNumberList, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(6, 4, 6, 4);
        groupNumberPanel.add((Component)new JLabel("Group Sizes"), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(6, 4, 6, 4);
        groupNumberPanel.add((Component)this.radioGroupRange, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        groupNumberPanel.add((Component)new JLabel("From"), gbc);
        ++gbc.gridx;
        gbc.anchor = 17;
        groupNumberPanel.add((Component)this.txtGroupFrom, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        groupNumberPanel.add((Component)new JLabel("To"), gbc);
        ++gbc.gridx;
        gbc.anchor = 17;
        groupNumberPanel.add((Component)this.txtGroupTo, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        groupNumberPanel.add((Component)new JLabel("By"), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        groupNumberPanel.add((Component)this.txtGroupBy, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
        groupNumberPanel.add((Component)this.radioGroupList, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 6;
        groupNumberPanel.add((Component)this.txtGroupNumberList, gbc);
        centerPanel.add((Component)compressionPanel, "North");
        centerPanel.add((Component)groupNumberPanel, "Center");
        theContentPane.add((Component)centerPanel, "Center");
        JButton btnOK = new JButton("Run");
        btnOK.addActionListener(this);
        btnOK.setActionCommand("OK");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(this);
        btnCancel.setActionCommand("Cancel");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(5, 4, 8, 4);
        buttonPanel.add((Component)btnOK, gbc);
        ++gbc.gridx;
        buttonPanel.add((Component)btnCancel, gbc);
        theContentPane.add((Component)buttonPanel, "South");
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("OK")) {
            this.setVisible(false);
        } else if (evt.getActionCommand().equals("Cancel")) {
            this.setVisible(false);
        } else if (evt.getActionCommand().equals("nomarkers")) {
            if (this.chkNoMarkers.isSelected()) {
                this.chkP3D.setEnabled(false);
            } else {
                this.chkP3D.setEnabled(true);
            }
        } else if (evt.getActionCommand().equals("compress")) {
            if (this.chkCompression.isSelected()) {
                this.chkUPGMA.setEnabled(true);
                this.chkNJ.setEnabled(true);
                this.chkAvg.setEnabled(true);
                this.chkMin.setEnabled(true);
                this.chkMax.setEnabled(true);
                this.chkMedian.setEnabled(true);
                this.radioGroupRange.setEnabled(true);
                this.radioGroupList.setEnabled(true);
                this.txtGroupBy.setEnabled(true);
                this.txtGroupFrom.setEnabled(true);
                this.txtGroupNumberList.setEnabled(true);
                this.txtGroupTo.setEnabled(true);
            } else {
                this.chkUPGMA.setEnabled(false);
                this.chkNJ.setEnabled(false);
                this.chkAvg.setEnabled(false);
                this.chkMin.setEnabled(false);
                this.chkMax.setEnabled(false);
                this.chkMedian.setEnabled(false);
            }
        }
    }

    ArrayList<Integer> getListOfGroups() {
        ArrayList<Integer> groupList = new ArrayList<Integer>();
        if (this.radioGroupList.isSelected()) {
            String[] groups = this.txtGroupNumberList.getText().split(",");
            int n = groups.length;
            try {
                for (int i = 0; i < n; ++i) {
                    groupList.add(Integer.parseInt(groups[i]));
                }
            }
            catch (Exception e) {
                String msg = "Illegal character in group list.";
                JOptionPane.showMessageDialog(this.getParent(), msg, "Illegal List", 0);
                return null;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        MLMNewOptionDialog mod = new MLMNewOptionDialog(null);
        mod.setVisible(true);
        System.exit(-1);
    }
}

