/*
 * Decompiled with CFR 0.152.
 */
package gbs;

import net.maizegenetics.analysis.data.MigrateHDF5FromT4T5;
import net.maizegenetics.analysis.gbs.AnnotateTOPM;
import net.maizegenetics.analysis.gbs.SimpleGenotypeSBit;
import net.maizegenetics.analysis.gbs.TagAgainstAnchor;
import net.maizegenetics.analysis.gbs.TagBlockPosition;
import net.maizegenetics.analysis.gbs.TagCountToFastqPlugin;
import net.maizegenetics.dna.map.TagsOnPhysicalMapV3;
import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.TagsByTaxa;

public class PipelineProduction {
    public PipelineProduction() {
        this.v3Pipeline();
        this.geneticMappingPipeline();
    }

    public void v3Pipeline() {
        this.annotateTOPMHDF5WithAligner();
    }

    public void annotateTOPMHDF5WithAligner() {
        String inputFileS = "M:/production/v3gbs/topm/ini.topm.h5";
        TagsOnPhysicalMapV3 topm = new TagsOnPhysicalMapV3(inputFileS);
        AnnotateTOPM anno = new AnnotateTOPM(topm);
        String bowtie2SamFileS = "M:/production/v3gbs/alignment/tags.bowtie2.sam.gz";
        anno.annotateWithBowtie2(bowtie2SamFileS, 5);
        String bwaSamFileS = "M:/production/v3gbs/alignment/tags.bwa.sam.gz";
        String bwaMemSamFileS = "M:/production/v3gbs/alignment/tags.bwa.sam.gz";
        String PETOPMFileS = "M:/production/pe/ptopm/PE.topm";
    }

    public void mkFasta() {
        String inputFileS = "M:/production/v3gbs/tagCount/AllZeaMasterTags_c10_20120606.cnt";
        String outputFileS = "M:/production/v3gbs/alignment/tags.fa";
        TagCounts tc = new TagCounts(inputFileS, TagsByTaxa.FilePacking.Byte);
        tc.toFASTA(outputFileS);
    }

    public void mkFastq() {
        String inputFileS = "M:/production/v3gbs/tagCount/AllZeaMasterTags_c10_20120606.cnt";
        String outputFileS = "M:/production/v3gbs/alignment/tags.fq";
        TagCountToFastqPlugin umithm = new TagCountToFastqPlugin();
        String arguments = "-i " + inputFileS + " -o " + outputFileS;
        String[] args = arguments.split(" ");
        umithm.setParameters(args);
        umithm.performFunction(null);
    }

    public void initializeTOPMHDF5() {
        String inputFileS = "M:/production/v3gbs/tagCount/AllZeaMasterTags_c10_20120606.cnt";
        String outputFileS = "M:/production/v3gbs/topm/ini.topm.h5";
        TagCounts tc = new TagCounts(inputFileS, TagsByTaxa.FilePacking.Byte);
        TagsOnPhysicalMapV3.createFile(tc, outputFileS);
    }

    public void geneticMappingPipeline() {
        this.geneticMapping();
    }

    public void geneticMapping() {
        String hapMapHDF5 = "/workdir/mingh/AllZeaGBSv27i3b.sBit.h5";
        String tbtHDF5 = "/workdir/mingh/mergeTBTHDF5_mergedtaxa_pivot_20120921.h5";
        String blockFileS = "/workdir/mingh/GBS27TagBlock.tbp";
        String outfileS = "/workdir/mingh/outfile.txt";
        TagAgainstAnchor taa = new TagAgainstAnchor(hapMapHDF5, tbtHDF5, blockFileS, outfileS, 1.0E-6, 20, -1, 32768, 2, 10);
    }

    public void mkTBTTagBlock() {
        String tbtHDF5 = "M:/production/geneticMapping/tbt/mergeTBTHDF5_mergedtaxa_pivot_20120921.h5";
        String topmFileS = "M:/production/v3gbs/topm/bowtie2.topm.h5";
        String blockFileS = "M:/production/geneticMapping/tagBlock/GBS27TagBlock.tbp";
        TagBlockPosition tbp = new TagBlockPosition(tbtHDF5, topmFileS, "Bowtie2");
        tbp.writeTagBlockPosition(blockFileS);
    }

    public void transformAnchorHDF5() {
        String hapMapInputFileS = "M:/production/geneticMapping/genotype/AllZeaGBSv27i3b.T5.imp.hmp.h5";
        String sBitFileS = "M:/production/geneticMapping/genotype/AllZeaGBSv27i3b.sBit.h5";
        new SimpleGenotypeSBit(hapMapInputFileS, sBitFileS);
    }

    public void migrateHDF5ToTASSEL5() {
        String hapMapInputS = "M:/production/geneticMapping/genotype/AllZeaGBSv27i3b.imp.hmp.h5";
        String hapMapOutputS = "M:/production/geneticMapping/genotype/AllZeaGBSv27i3b.T5.imp.hmp.h5";
        MigrateHDF5FromT4T5.copyGenotypes(hapMapInputS, hapMapOutputS);
    }

    public static void main(String[] args) {
        new PipelineProduction();
    }
}

