/*
 * Decompiled with CFR 0.152.
 */
package format.text;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import net.maizegenetics.dna.tag.SAMUtils;
import net.maizegenetics.util.MultiMemberGZIPInputStream;

public class SimpleAlignment {
    AlignmentInfo[] ai;
    byte sortType = 0;

    public SimpleAlignment() {
    }

    public SimpleAlignment(String alignmentFileS) {
        this.readSimpleAlignment(alignmentFileS);
    }

    public int getAlignmentNumber() {
        return this.ai.length;
    }

    public int getAlignmentNumberByHit(String hit) {
        if (this.sortType == 0) {
            return -1;
        }
        return this.getAlignmentStartIndexByHit(hit) - this.getAlignmentEndIndexByHit(hit);
    }

    public int getAlignmentNumberByQuery(String query) {
        if (this.sortType == 1) {
            return -1;
        }
        return this.getAlignmentStartIndexByQuery(query) - this.getAlignmentEndIndexByQuery(query);
    }

    public int getAlignmentStartIndexByHit(String hit) {
        int index;
        if (this.sortType == 0) {
            return -1;
        }
        int index1 = Arrays.binarySearch(this.ai, this.ai[0]);
        for (index = Arrays.binarySearch(this.ai, new AlignmentInfo(null, hit)); index > 0 && this.ai[index - 1].hit.equals(hit); --index) {
        }
        return index;
    }

    public int getAlignmentStartIndexByQuery(String query) {
        int index;
        if (this.sortType == 1) {
            return -1;
        }
        for (index = Arrays.binarySearch(this.ai, new AlignmentInfo(query, null)); index > 0 && this.ai[index - 1].query.equals(query); --index) {
        }
        return index;
    }

    public int getAlignmentStartIndexByQueryStartWith(String queryStartWith) {
        if (this.sortType == 1) {
            return -1;
        }
        int index = Arrays.binarySearch(this.ai, new AlignmentInfo(queryStartWith, null));
        if (index < 0) {
            if (this.getQuery(index = -index - 1).startsWith(queryStartWith)) {
                return index;
            }
            return Integer.MIN_VALUE;
        }
        return index;
    }

    public int getAlignmentEndIndexByHit(String hit) {
        if (this.sortType == 0) {
            return -1;
        }
        int index = Arrays.binarySearch(this.ai, new AlignmentInfo(null, hit));
        while (index + 1 < this.getAlignmentNumber() && this.ai[index + 1].hit.equals(hit)) {
            ++index;
        }
        return index + 1;
    }

    public int getAlignmentEndIndexByQuery(String query) {
        if (this.sortType == 1) {
            return -1;
        }
        int index = Arrays.binarySearch(this.ai, new AlignmentInfo(query, null));
        while (index + 1 < this.getAlignmentNumber() && this.ai[index + 1].query.equals(query)) {
            ++index;
        }
        return index + 1;
    }

    public int getAlignmentEndIndexByQueryStartWith(String queryStartWith) {
        if (this.sortType == 1) {
            return -1;
        }
        int index = this.getAlignmentStartIndexByQueryStartWith(queryStartWith);
        if (index < 0) {
            return index;
        }
        while (index + 1 < this.getAlignmentNumber() && this.ai[index + 1].query.startsWith(queryStartWith)) {
            ++index;
        }
        return index + 1;
    }

    public String[] getQuerys() {
        TreeSet<String> querySet = new TreeSet<String>();
        for (int i = 0; i < this.getAlignmentNumber(); ++i) {
            querySet.add(this.ai[i].query);
        }
        return querySet.toArray(new String[querySet.size()]);
    }

    public String[] getHits() {
        TreeSet<String> hitSet = new TreeSet<String>();
        for (int i = 0; i < this.getAlignmentNumber(); ++i) {
            hitSet.add(this.ai[i].hit);
        }
        return hitSet.toArray(new String[hitSet.size()]);
    }

    public String getQuery(int index) {
        return this.ai[index].query;
    }

    public String getHit(int index) {
        return this.ai[index].hit;
    }

    public int getStartPos(int index) {
        return this.ai[index].startPos;
    }

    public int getEndPos(int index) {
        return this.ai[index].endPos;
    }

    public boolean isMatch(int index) {
        return this.ai[index].hit != null;
    }

    public boolean isPerfectMatch(int index) {
        return this.ai[index].ifPerfectMatch;
    }

    public boolean isUniquePerfectMatch(String query) {
        int startIndex = this.getAlignmentStartIndexByQuery(query);
        int endIndex = this.getAlignmentEndIndexByQuery(query);
        int cnt = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            if (this.isPerfectMatch(i)) {
                ++cnt;
            }
            if (cnt <= 1) continue;
            return false;
        }
        return cnt != 0;
    }

    public byte getStrand(int index) {
        return this.ai[index].strand;
    }

    public byte getSortType() {
        return this.sortType;
    }

    public void toSubset(boolean[] keepList) {
        int cnt = 0;
        for (int i = 0; i < keepList.length; ++i) {
            if (!keepList[i]) continue;
            ++cnt;
        }
        AlignmentInfo[] sub = new AlignmentInfo[cnt];
        cnt = 0;
        for (int i = 0; i < keepList.length; ++i) {
            if (!keepList[i]) continue;
            sub[cnt] = this.ai[i];
            ++cnt;
        }
        this.ai = sub;
    }

    public void readFromBowtie2(String inputFileS) {
        ArrayList<AlignmentInfo> aList = new ArrayList<AlignmentInfo>();
        System.out.println("Reading SAM format tag alignment (Bowtie2) from: " + inputFileS);
        try {
            BufferedReader br = inputFileS.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(new File(inputFileS))))) : new BufferedReader(new FileReader(new File(inputFileS)), 65536);
            while (!br.readLine().startsWith("@PG")) {
            }
            String inputStr = null;
            int cnt = 0;
            while ((inputStr = br.readLine()) != null) {
                String[] temp = inputStr.split("\\s");
                int orientiation = Integer.parseInt(temp[1]);
                String hit = null;
                byte strand = -128;
                int startPos = Integer.MIN_VALUE;
                int endPos = Integer.MIN_VALUE;
                boolean ifPerfectMatch = false;
                if (orientiation != 4) {
                    int[] alignSpan;
                    if (orientiation == 16 || orientiation == 272) {
                        hit = temp[2];
                        strand = -1;
                        alignSpan = SAMUtils.adjustCoordinates(temp[5], Integer.parseInt(temp[3]));
                        startPos = alignSpan[1];
                        endPos = alignSpan[0];
                        if (temp[17].startsWith("NM")) {
                            if (temp[5].equals(String.valueOf(temp[9].length()) + "M") && Byte.parseByte(temp[17].split(":")[2]) == 0) {
                                ifPerfectMatch = true;
                            }
                        } else if (temp[5].equals(String.valueOf(temp[9].length()) + "M") && Byte.parseByte(temp[16].split(":")[2]) == 0) {
                            ifPerfectMatch = true;
                        }
                    } else {
                        hit = temp[2];
                        strand = 1;
                        alignSpan = SAMUtils.adjustCoordinates(temp[5], Integer.parseInt(temp[3]));
                        startPos = alignSpan[0];
                        endPos = alignSpan[1];
                        if (temp[17].startsWith("NM")) {
                            if (temp[5].equals(String.valueOf(temp[9].length()) + "M") && Byte.parseByte(temp[17].split(":")[2]) == 0) {
                                ifPerfectMatch = true;
                            }
                        } else if (temp[5].equals(String.valueOf(temp[9].length()) + "M") && Byte.parseByte(temp[16].split(":")[2]) == 0) {
                            ifPerfectMatch = true;
                        }
                    }
                }
                aList.add(new AlignmentInfo(temp[0], hit, startPos, endPos, strand, ifPerfectMatch));
                if (cnt % 500000 == 0) {
                    System.out.println("Read in " + String.valueOf(cnt) + " lines");
                }
                ++cnt;
            }
            this.ai = aList.toArray(new AlignmentInfo[aList.size()]);
            this.sortByQuery();
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void readSimpleAlignment(String alignmentFileS) {
        try {
            String temp;
            BufferedReader br = new BufferedReader(new FileReader(alignmentFileS), 65536);
            br.readLine();
            ArrayList<AlignmentInfo> aList = new ArrayList<AlignmentInfo>();
            while ((temp = br.readLine()) != null) {
                String[] tem = temp.split("\t");
                AlignmentInfo info = new AlignmentInfo(tem[0], tem[1], Integer.valueOf(tem[2]), Integer.valueOf(tem[3]), Byte.valueOf(tem[4]), tem[5].equals("1"));
                aList.add(info);
            }
            this.ai = aList.toArray(new AlignmentInfo[aList.size()]);
            br.close();
            this.sortByQuery();
            System.out.println(alignmentFileS + " is load and sorted by query");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void writeSimpleAlignment(String outfileS) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            bw.write("Query\tChromosome\tStartPos\tEndPos\tStrand\tIfPerfectMatch");
            bw.newLine();
            for (int i = 0; i < this.getAlignmentNumber(); ++i) {
                bw.write(this.ai[i].toString());
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void sortByQuery() {
        this.sortType = 0;
        Arrays.sort(this.ai);
    }

    public void sortByHit() {
        this.sortType = 1;
        Arrays.sort(this.ai);
    }

    public void sortByHitPos() {
        this.sortType = 1;
        Arrays.sort(this.ai, new SortByHitPos());
    }

    class AlignmentInfo
    implements Comparable<AlignmentInfo> {
        String query = null;
        String hit = null;
        int startPos = Integer.MIN_VALUE;
        int endPos = Integer.MIN_VALUE;
        byte strand = (byte)-128;
        boolean ifPerfectMatch = false;

        AlignmentInfo(String query, String hit) {
            this.query = query;
            this.hit = hit;
        }

        AlignmentInfo(String query, String hit, int startPos, int endPos, byte strand, boolean ifPerfectMatch) {
            this.query = query;
            this.hit = hit;
            this.startPos = startPos;
            this.endPos = endPos;
            this.strand = strand;
            this.ifPerfectMatch = ifPerfectMatch;
        }

        @Override
        public int compareTo(AlignmentInfo o) {
            if (SimpleAlignment.this.sortType == 0) {
                return this.query.compareTo(o.query);
            }
            if (SimpleAlignment.this.sortType == 1) {
                return this.hit.compareTo(o.hit);
            }
            return 0;
        }

        public String toString() {
            String s = this.query + "\t" + this.hit + "\t" + String.valueOf(this.startPos) + "\t" + String.valueOf(this.endPos) + "\t" + String.valueOf(this.strand) + "\t";
            s = this.ifPerfectMatch ? s + "1" : s + "0";
            return s;
        }
    }

    private class SortByHitPos
    implements Comparator<AlignmentInfo> {
        private SortByHitPos() {
        }

        @Override
        public int compare(AlignmentInfo o1, AlignmentInfo o2) {
            if (o1.hit.equals(o2.hit)) {
                return o1.startPos - o2.startPos;
            }
            return o1.hit.compareTo(o2.hit);
        }
    }
}

