/*
 * Decompiled with CFR 0.152.
 */
package format.text;

import format.text.Fasta;

public class Sequence {
    String seq = null;

    public Sequence(String seq) {
        this.seq = seq;
    }

    public String[] getFragments(int fragmentLength) {
        int len = this.seq.length();
        int left = len % fragmentLength;
        int fragmentNumber = left == 0 ? len / fragmentLength : len / fragmentLength + 1;
        String[] fragments = new String[fragmentNumber];
        if (left == 0) {
            for (int i = 0; i < fragmentNumber; ++i) {
                fragments[i] = this.seq.substring(i * fragmentLength, i * fragmentLength + fragmentLength);
            }
        } else {
            for (int i = 0; i < fragmentNumber - 1; ++i) {
                fragments[i] = this.seq.substring(i * fragmentLength, i * fragmentLength + fragmentLength);
            }
            fragments[fragmentNumber - 1] = this.seq.substring((fragmentNumber - 1) * fragmentLength, this.seq.length());
        }
        return fragments;
    }

    public Fasta getFragmentsFasta(int fragmentLength, String prefix) {
        String[] fragments = this.getFragments(fragmentLength);
        String[] names = new String[fragments.length];
        int[] ids = new int[fragments.length];
        for (int i = 0; i < fragments.length; ++i) {
            names[i] = prefix + String.valueOf(i + 1);
            ids[i] = i + 1;
        }
        return new Fasta(names, fragments, ids);
    }
}

