/*
 * Decompiled with CFR 0.152.
 */
package format.text;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

public class Bins {
    int corStart;
    int corEnd;
    Range[] bins;

    public Bins(int corStart, int corEnd, int rangeLength, int[] coordinate, double[] v) {
        this.initialize(corStart, corEnd, rangeLength);
        this.addValues(coordinate, v);
    }

    public Bins(int corStart, int corEnd, int rangeLength) {
        this.initialize(corStart, corEnd, rangeLength);
    }

    private void initialize(int corStart, int corEnd, int rangeLength) {
        this.corStart = corStart;
        this.corEnd = corEnd;
        int maxLength = corEnd - corStart;
        int base = maxLength % rangeLength;
        int binNum = base == 0 ? maxLength / rangeLength : maxLength / rangeLength + 1;
        this.bins = new Range[binNum];
        for (int i = 0; i < binNum; ++i) {
            int actualLength = rangeLength;
            if (i == binNum - 1 && base != 0) {
                actualLength = base;
            }
            this.bins[i] = new Range(i * rangeLength + corStart, i * rangeLength + corStart + actualLength);
        }
        Arrays.sort(this.bins);
    }

    public int getBinNum() {
        return this.bins.length;
    }

    public int getCoordinateStart() {
        return this.corStart;
    }

    public int getCoordinateEnd() {
        return this.corEnd;
    }

    public int getBinStart(int binIndex) {
        return this.bins[binIndex].start;
    }

    public int getBinEnd(int binIndex) {
        return this.bins[binIndex].end;
    }

    public double getBinMean(int binIndex) {
        return this.bins[binIndex].mean;
    }

    public double getBinSD(int binIndex) {
        return this.bins[binIndex].sd;
    }

    public double[] getBinValues(int binIndex) {
        return this.bins[binIndex].values;
    }

    public void addValues(int[] coordinate, double[] v) {
        int i;
        ArrayList[] vs = new ArrayList[this.bins.length];
        for (i = 0; i < vs.length; ++i) {
            vs[i] = new ArrayList();
        }
        for (i = 0; i < coordinate.length; ++i) {
            Range query = new Range(coordinate[i], coordinate[i]);
            int index = Arrays.binarySearch(this.bins, query);
            if (index <= 0) {
                if (index < -1 && index >= -this.bins.length) {
                    index = -index - 2;
                } else if (index != -1 && index < -this.bins.length) {
                    index = -index - 2;
                    if (coordinate[i] >= this.bins[index].end) {
                        index = -1;
                    }
                }
            }
            if (index < 0) continue;
            vs[index].add(v[i]);
        }
        for (i = 0; i < this.bins.length; ++i) {
            this.bins[i].addValues(vs[i]);
        }
    }

    public void writeBinSummary(String outfileS) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            bw.write("BinStart\tBinEnd\tMean\tSD");
            bw.newLine();
            for (int i = 0; i < this.bins.length; ++i) {
                bw.write(String.valueOf(this.bins[i].start) + "\t" + String.valueOf(this.bins[i].end) + "\t" + String.valueOf(this.bins[i].mean) + "\t" + String.valueOf(this.bins[i].sd));
                bw.newLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class Range
    implements Comparable<Range> {
        int start;
        int end;
        double[] values = null;
        double sd = Double.NaN;
        double mean = Double.NaN;

        Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        void addValues(ArrayList<Double> list) {
            if (list.isEmpty()) {
                this.values = null;
                this.sd = Double.NaN;
                this.mean = Double.NaN;
            } else {
                this.values = new double[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    this.values[i] = list.get(i);
                }
                DescriptiveStatistics ds = new DescriptiveStatistics(this.values);
                this.mean = ds.getMean();
                this.sd = ds.getStandardDeviation();
            }
        }

        @Override
        public int compareTo(Range o) {
            return this.start - o.start;
        }
    }
}

